/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tu41mc;

import com.cinterion.io.ATCommand;
import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.I2cBusConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.CommConnection;
import javax.microedition.io.Connector;
import javax.microedition.midlet.*;

/**
 * @author nshulgina
 */
public class IMlet extends MIDlet {
    
    I2cBusConnection cc;
    InputStream inI2C;
    OutputStream outI2C;
    
    CommConnection com;
    InputStream isCom;
    OutputStream osCom;    
    
    private static final String writeAddress = "A2";
    private static final String readAddress = "A3";
    
    private static final String keepalive = "at$java\r";
    private static final byte[] keepaliveBytes = keepalive.getBytes();
    
    private static final String led3gStart = "at$gsm3g=";
    private static final String simStart = "at$simok=";
    
    private static String i2CEnd = "00";
    private static byte atEnd = '\r';
    
    private static boolean debug = false;
    
    private static byte[] bytes = new byte[520];
    private static char[] chars = new char[260];
    
    private static int nextI2CId = 'a';
    
    private static long lastKeepalive = 0;
    private static long keepalivePeriod = 40000;
    
    private static boolean now3g = false;
    private static int nowCsq = 0;
    private static boolean changed3g = false;
    
    private static boolean simChanged = false;
    private static boolean simInserted = false;
    private static int simRegistered = 0;
    
    private static final byte[] rs232to422 = "at$rs232tors422\r".getBytes();
    private static final byte[] rs422to232 = "at$rs422tors232\r".getBytes();
    private static final byte[] rs232to422ok = "$rs232tors422\rOK\r\n".getBytes();
    private static final byte[] rs422to232ok = "$rs422tors232\rOK\r\n".getBytes();
    private static final byte[] rs232to422err = "$rs232tors422\rERROR\r\n".getBytes();
    private static final byte[] rs422to232err = "$rs422tors232\rERROR\r\n".getBytes();
    
    public void startApp() {
        log("app started");
        
        ATCommand atCommand;
        while (true) {
           try {
               atCommand = new ATCommand(false);
               break;
           } catch (ATCommandFailedException e) {
               log("NOT got ATCommand");
               try {
                   Thread.sleep(1000);
               } catch (InterruptedException ex) {}               
           }
        }  
        log("got ATCommand");
        
        try {
            String scfg = atCommand.send("AT^SCFG?\r");
            log(scfg);
            if (scfg.indexOf("\"Gpio/mode/SYNC\",\"std\"") < 0) {
                scfg = atCommand.send("AT^SCFG=\"GPIO/mode/SYNC\",\"std\"\r");  //switch led on
                log(scfg);
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {}
                scfg = atCommand.send("AT&W\r");
                log(scfg);
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {}
                scfg = atCommand.send("AT+CFUN=1,1\r");
                log(scfg);
                destroyApp(true);
                return;
            }
       } catch (ATCommandFailedException e) {}        
        
        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {}
        
        try {
            atCommand.send("AT^SLED=2,50\r");
        } catch (ATCommandFailedException e) {}
        
        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {}
        
        try {
            atCommand.send("AT^SCFG=\"Gpio/mode/ASC1\",\"std\"\r");
        } catch (ATCommandFailedException e) {}
        
        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {}
        
        try {
            atCommand.send("AT^SCFG=\"Serial/Interface/Allocation\",\"1\"\r");
        } catch (ATCommandFailedException e) {}
        
        new LedThread(atCommand).start();
        
        while (true) { 
            try {
                openI2CTillSuccess();
                log("i2c opened");

                openComTillSuccess();
                log("com opened");

                while (true) {
                
                    int pos = readComBlocking();
                    if (pos > 0) {
                        boolean isRs232 = arraysEqual(bytes, pos, rs232to422);  //command to test RS232 and RS422 after production
                        boolean isRs422 = arraysEqual(bytes, pos, rs422to232);
                        if (isRs232 || isRs422) {
                            CommConnection rs232 = null;
                            CommConnection rs422 = null;
                            OutputStream os = null;
                            InputStream is = null;
                            try {
                                rs232 = openRs(true);
                                rs422 = openRs(false);                                
                                byte[] toWrite = (isRs232 ? rs232to422 : rs422to232);
                                log(isRs232 ? "will write 232 to 422" : "will write 422 to 232");
                                if (isRs232) {
                                    os = rs232.openOutputStream();
                                    is = rs422.openInputStream();
                                    log("os for 232, is for 422");
                                } else {
                                    os = rs422.openOutputStream();
                                    is = rs232.openInputStream();
                                    log("os for 422, is for 232");
                                }                            
                                os.write(toWrite);
                                log("wrote: " + new String(toWrite));
                                try {
                                    Thread.sleep(1000);
                                } catch (InterruptedException ex) {}
                                byte[] read = new byte[is.available()];                                
                                is.read(read);
                                log("read " + read.length + " bytes: " + new String(read));
                                if (arraysEqual(toWrite, toWrite.length, read)) {
                                    osCom.write(isRs232 ? rs232to422ok : rs422to232ok);
                                } else {
                                    osCom.write(isRs232 ? rs232to422err : rs422to232err);
                                }
                            } catch (IOException ex) {
                                log(ex);
                                osCom.write(isRs232 ? rs232to422err : rs422to232err);
                            } finally {
                                silentClose(os);
                                silentClose(is);
                                silentClose(rs232);
                                silentClose(rs422);                                
                            }
                        } else {
                            String command = "<".concat("" + (char)nextI2CId).concat(writeAddress).concat(bytesToHex(bytes, 0, pos)).concat(">");
                            log(command);                        
                            outI2C.write(command.getBytes());
                            outI2C.flush();
                            lastKeepalive = System.currentTimeMillis();

                            pos = readI2CAnswer();
                            if (pos == 0) {
                                throw new IOException("null answer");
                            }                    
                            String ans = new String(bytes, 0, pos);
                            log(ans);
                            if (!ans.equalsIgnoreCase("{" + (char) nextI2CId + "+}")) {
                                throw new IOException ("not acknowledge");
                            }
                            incrNextI2CId();

                            try {
                                Thread.sleep(300);
                            } catch (InterruptedException ex) {}

                            byte[] read = ("<" + (char) nextI2CId + readAddress + "00FA>").getBytes();
                            log(new String(read));
                            outI2C.write(read);
                            outI2C.flush();   
                            lastKeepalive = System.currentTimeMillis();

                            pos = readI2CAnswer();
                            if (pos == 0) {
                                throw new IOException("null answer");
                            }

                            String s = new String(bytes, 0, pos);
                            log("raw answer: " + s + ", hex from: " + s.substring(3, s.length()-1));
                            pos = hexToBytes(s.substring(3, s.length()-1));
                            incrNextI2CId();
                            if (pos == 0) {
                                throw new IOException("invalid hex message");
                            }
                            ans = new String(bytes, 0, pos);
                            log(ans);

                            osCom.write(bytes, 0, pos);    
                            osCom.flush();
                            log("wrote to com " + pos + " bytes");
                        }
                    }            
                }
            } catch (IOException ex) {
                log(ex);
                closeI2C();
                silentCloseCom();

                try {
                    Thread.sleep(2000);
                } catch (InterruptedException exx) {}
            }
        }
    }
    
    private boolean arraysEqual(byte[] one, int length, byte[] two) {
        if (one.length < length || two.length != length) {
            log("one length: " + one.length + ", length: " + length + ", two length: " + two.length);
            return false;
        }
        for (int i=0; i<length; i++) {
            if (one[i] != two[i]) {
                log("not equal symbol number " + i + ", one " + (int) one[i] + ", two " + (int) + two[i] + ", one: " + new String(one) + ", two: " + new String(two));
                return false;
            }
        }
        return true;
    }
    
    private void sendKeepalive() throws IOException {
        log(keepalive);
        String command = "<".concat("" + (char) nextI2CId).concat(writeAddress).concat(bytesToHex(keepaliveBytes, 0, keepaliveBytes.length)).concat(">");
        log(command);
        outI2C.write(command.getBytes());
        outI2C.flush();

        int pos = readI2CAnswer();
        if (pos == 0) {
            throw new IOException("null answer");
        }                    
        String ans = new String(bytes, 0, pos);
        log(ans);
        if (!ans.equalsIgnoreCase("{" + (char) nextI2CId + "+}")) {
            throw new IOException ("not acknowledge");
        }
        lastKeepalive = System.currentTimeMillis();
        incrNextI2CId();
    }
    
    public static void changedSignal(boolean available, int csq) {
        changed3g = true;
        now3g = available;
        nowCsq = csq;
    }
    
    public static void simInfoChanged(boolean ins, int reg) {
        simChanged = true;
        simInserted = ins;
        simRegistered = reg;
    }
    
    private void incrNextI2CId() {
        nextI2CId = nextI2CId + 1;
        if (nextI2CId > 'z') {
            nextI2CId = 'a';
        }
    }
    
    private void send3gAvailable(boolean available, int csq) throws IOException {
        String atCom = led3gStart + (available ? "1" : "0") + "," + csq + (char) atEnd;
        processWaitAck(atCom);
    }
    
    private void sendSimChanged(boolean ins, int reg) throws IOException {
        String atCom = simStart + (ins ? 1 : 0) + "," + reg + (char) atEnd;
        processWaitAck(atCom);
    }
    
    private void processWaitAck(String atCom) throws IOException {
        byte[] b = atCom.getBytes();
        log(atCom);
        String command = "<".concat("" + (char) nextI2CId).concat(writeAddress).concat(bytesToHex(b, 0, b.length)).concat(">");
        log(command);
        outI2C.write(command.getBytes());
        outI2C.flush();

        int pos = readI2CAnswer();
        if (pos == 0) {
            throw new IOException("null answer");
        }                    
        String ans = new String(bytes, 0, pos);
        log(ans);
        if (!ans.equalsIgnoreCase("{" + (char) nextI2CId + "+}")) {
            throw new IOException ("not acknowledge");
        }
        lastKeepalive = System.currentTimeMillis();
        incrNextI2CId();
    }
    
    private void sendPeriodicCommands() throws IOException {
        if (changed3g) {
            changed3g = false;
            send3gAvailable(now3g, nowCsq);  
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ex) {}
        }
        
        if (simChanged) {
            simChanged = false;
            sendSimChanged(simInserted, simRegistered);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ex) {}
        }

        if (System.currentTimeMillis() - lastKeepalive > keepalivePeriod) {
            sendKeepalive();
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ex) {}
        }
    }
    
    private int readComBlocking() throws IOException {
        isCom.skip(isCom.available());    
        
        int pos = 0;
        while (true) {
            if (pos >= bytes.length) {
                pos = 0;
            }
            
            while (isCom.available() < 1) {
                sendPeriodicCommands();
                try {
                    Thread.sleep(50);
                } catch (InterruptedException ex) {}                
            }
            
            isCom.read(bytes, pos++, 1);
            if (bytes[pos-1] == atEnd) {
                break;
            }
        }
        return pos;
    }
    
    private CommConnection openRs(boolean rs232) throws IOException {
        CommConnection rs = (CommConnection) Connector.open("comm:COM" + (rs232 ? "0" : "1") + ";bitsperchar=8;stopbits=1;parity=none;baudrate=115200");
        return rs;
    }
    
    private void openComTillSuccess() throws IOException {
        while (true) {
            try {
                com = (CommConnection) Connector.open("comm:USB4;blocking=off;autocts=off;bitsperchar=8;stopbits=1;parity=none;baudrate=115200");
                isCom = com.openInputStream();
                osCom = com.openOutputStream();
                break;
            } catch (IOException e) {
                log(e);
                silentCloseCom();
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException ex) {}
                
                sendPeriodicCommands();
            }
        }
    }
    
    private void openI2CTillSuccess() {
        while (true) {
            try {
                cc = (I2cBusConnection) Connector.open("i2c:0;baudrate=100");                       
                inI2C  = cc.openInputStream();
                outI2C = cc.openOutputStream();
                break;
            } catch (IOException ex) {
                log(ex);
                closeI2C();
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {}
            }
        }
    }
    
    private int readI2CAnswer() throws IOException {
        int pos = 0;
        for (int i=0; i<4; i++) {
            if (inI2C.available() > 0) {
                inI2C.read(bytes, pos++, 1); 
                i--;
                if (bytes[pos-1] == (byte) '}') {
                    break;
                }                
            } else {
                try {
                    Thread.sleep(200);
                } catch (InterruptedException ex) {}
            }
        }
        return pos;
    }
    
    public static void log(String s) {
        if (debug) {
            System.out.println(s);
        }
    }
    
    public static void log(Exception e) {
        if (debug) {
            e.printStackTrace();
        }
    }
    
    private void closeI2C() {
        if (inI2C != null) {
            try {
                inI2C.close();
            } catch (IOException ex) {}
        }
        if (outI2C != null) {
            try {
                outI2C.close();
            } catch (IOException ex) {}
        }
        if (cc != null) {
            try {
                cc.close();
            } catch (IOException ex) {}
        }        
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) {
        closeI2C();
        silentCloseCom();
        notifyDestroyed();
    }
    
    final protected static char[] hexArray = "0123456789ABCDEF".toCharArray();
    
    public static String bytesToHex(byte[] bytes, int start, int length) {
        int j;
        for (j = start; j < length; j++ ) {
            int v = bytes[j] & 0xFF;
            chars[(j - start) * 2] = hexArray[v >>> 4];
            chars[(j - start) * 2 + 1] = hexArray[v & 0x0F];
        }
        return new String(chars, 0, (j-start)*2);   //TODO: +2 was here
    }
    
    public static int hexToBytes(String hex) {
        int pos = hex.indexOf(i2CEnd);
        while (pos % 2 == 1 && pos != -1) {
            pos = hex.indexOf(i2CEnd, pos+1);
        }
        if (pos > -1) {
            hex = hex.substring(0, pos);
        }
        
        final int len = hex.length();
        if (len%2 != 0) {
            return 0;
        }
        
        int i;
        for (i=0; i<len; i+=2) {
            int h = hexToBin(hex.charAt(i));
            int l = hexToBin(hex.charAt(i+1));
            if (h==-1 || l==-1) {
                return 0;
            }            

            bytes[i/2] = (byte)(h*16+l);
        }

        return i/2;
    }
    
    private static int hexToBin( char ch ) {
        if( '0'<=ch && ch<='9' )    return ch-'0';
        if( 'A'<=ch && ch<='F' )    return ch-'A'+10;
        if( 'a'<=ch && ch<='f' )    return ch-'a'+10;
        return -1;
    }
    
    private void silentCloseCom() {
        silentClose(osCom);
        silentClose(isCom);
        silentClose(com);
    }
    
    private void silentClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            } catch (IOException ex) {}
        }
    }
    
    private void silentClose(OutputStream is) {
        if (is != null) {
            try {
                is.close();
            } catch (IOException ex) {}
        }
    }
    
    private void silentClose(CommConnection is) {
        if (is != null) {
            try {
                is.close();
            } catch (IOException ex) {}
        }
    }

}
